@echo off
if "%OS%" == not "Windows_NT" goto done
cd ..
cls
title DOSBox Configuration
if not exist dosbox.conf goto create_conf
:start
if exist "%WINDIR%\notepad.exe" goto open_conf
if exist "%SystemRoot%\system32\notepad.exe" goto open_conf
echo Couldn't find notepad.exe in your system.
pause >nul
goto done

:open_conf
echo Opening DOSBox Configuration...
if exist "%WINDIR%\notepad.exe" "%WINDIR%\notepad.exe" dosbox.conf && goto done
if exist "%SystemRoot%\system32\notepad.exe" "%SystemRoot%\system32\notepad.exe" dosbox.conf && goto done
goto done

:create_conf
set configfile_d3d=".\Tools\config_template\dosbox_direct3d.conf"
set configfile_ddraw=".\Tools\config_template\dosbox_ddraw.conf"
set configfile_default=".\Tools\config_template\dosbox_default.conf"
if not exist %configfile_d3d% goto done
if not exist %configfile_ddraw% goto done
if not exist %configfile_default% goto done
cls
echo DOSBox will now create a configuration file.
echo.
echo  Which one are you going to use for DOSBox?
echo  1) Focus on performance (recommended)
echo     output=direct3d, scaler=hardware2x, fullresolution=desktop
echo  2) Focus on compatibility
echo     output=ddraw, scaler=normal2x, fullresolution=desktop
echo  3) SVN default settings
echo     output=surface, scaler=normal2x, fullresolution=original
set /p me=
if "%me%" == "1" set configfile=%configfile_d3d% && goto create_conf_start
if "%me%" == "2" set configfile=%configfile_ddraw% && goto create_conf_start
if "%me%" == "3" set configfile=%configfile_default% && goto create_conf_start
goto create_conf

:create_conf_start
cls
echo.
echo Creating new DOSBox Configuration...
echo.
if not exist %configfile% goto done
copy %configfile% .\dosbox.conf >nul
if exist stdout.txt del stdout.txt
if exist dosbox.conf goto start
goto done

:done
set me=
set configfile=
set configfile_d3d=
set configfile_ddraw=
set configfile_default=
